/**
 *
 * \file        hprfgw_rfApp.h
 *
 * \brief       RF application task
 *
 * \detial      
 * \author      Hazrat Shah	
 *
 * \date        11/01/2006
 * \warning		
 * \note
 * \review	
 *
 */
#ifndef _HPRFGW_RFAPP_H_
	#define _HPRFGW_RFAPP_H_

//#include "datatypes.h"
#include "hprfgw_rfSharedDefs.h"
#include "hprfgw_rfDesc.h"
#include "hprfgw_rfPkt.h"

#ifdef  __cplusplus
extern "C" 
{
#endif


////////////////////////////////////////////////////////////////////////////////
//	DEFINES
////////////////////////////////////////////////////////////////////////////////
//	RF Device internal header, set when posting a packet to the rf application task  
typedef	struct	{
	UINT8	source;								//	source		
	UINT8	index;								//	descriptor table index 	
	UINT8	rfid;								//	device rfid
	UINT32	unused; 							//	unused	
}	TYPE_RFAPP_DEVICE_INTERNAL_HDR;
typedef	struct	{
	TYPE_RFAPP_DEVICE_INTERNAL_HDR inthdr;		//	Internal RF packet header	
	TYPE_INTERNAL_RF_PACKET_HEADER pkthdr;		//	packet header
	UINT8	data[RF_DEVICE_DATA_HOLD_BUFFER_SIZE];
}	TYPE_RFAPP_DATA_BUF;

#ifdef	RF_NETWORK_MASTER_DEVICE	
	#define	RFACQUIRE_PROCESS_DEFAULT_TIMEOUT	30	//	Acquire process timeout in the minutes 	
	#define	RFACQUIRE_PROCESS_MAX_TIMEOUT		180	//	Acquire process maximum timeout in the minutes 	
#else
	#define	RFACQUIRE_PROCESS_DEFAULT_TIMEOUT	2	//	Acquire process timeout in the minutes 	
	#define	RFACQUIRE_PROCESS_MAX_TIMEOUT		5	//	Acquire process maximum timeout in the minutes 	
#endif

typedef	struct	{
	UINT32	repeatno;						
	UINT32	invalidresponses;
	UINT32	noresponses;
	UINT8	localrxlqi;						
	UINT8	remoterxlqi;						
	UINT32	avgrxlqi;					
	UINT32	avgremotedevicerxlqi;
	UINT32	tick;	
	UINT32	txpacketcount;
	UINT32	txpacketpayloadbytecount;
	UINT32	rxpacketcount;
	UINT32	rxpacketpayloadbytecount;	

	BOOL	done;							//	TRUE=if tests are complete
}	TYPE_RF_ECHO_REPLY_PACKET;	

typedef	struct	{
	INT32	(*pcbf) (TYPE_RF_ECHO_REPLY_PACKET *pEchoReply);	//	call back function		
	UINT8	rfid;							//	rfid to conduct com with (in slave device(s) eg TPS this field is not used)
	UINT32	repeats;						//	repeat count
	UINT8	buf[RF_ECHO_PACKET_DATA_LEN];	//	data to be echoed
	UINT32	buflen;							
	BOOL	start;							//	TRUE=start, FALSE=stop
}	TYPE_RF_ECHO_REQUEST_PACKET;	

//	RF Discover reply parameters  
typedef	struct	{
	TYPE_RF_DISCOVERY_REPLY_PACKET_DATA disc;	
	UINT8	uid[UID_MAX_SIZE];
	UINT16	panid;
	UINT8	addrmode;
	UINT8	channel;	
	UINT8	linkqualityatlocaldevice;
}	TYPE_RF_DISCOVER_REPLY;	

//	RF Discover request parameters  
typedef	struct	{
	INT32	(*pcbf) (TYPE_RF_DISCOVER_REPLY *pRFDisReply, BOOL detial);	//	call back function		
	UINT8	service;						//	preform rf discover service (query...)
	UINT8	firstchannel;					//	preform scan on first channel 
	UINT8	lastchannel;					//	preform scan on last channel 
	BOOL	scan;							//	preform scan (over the air) if set, otherwise parse list 
	BOOL	detailview;						//  disp detail view
	UINT32	flags;							//	request flags
	BOOL	waitforto;						//	wait for timeout
}	TYPE_RF_DISCOVER_REQUEST;	

//#define	RF_NETWORK_REMOTE_SETUP

#define	SLAVE_DEVICE_DEFAULT_RFLINK_LQI_THR			180	//	-1*(180/2)=-90dBm
#define GATEWAY_DEVICE_DEFAULT_RFLINK_LQI_THR		180	//	-1*(180/2)=-90dBm 

#define	GATEWAY_DEFAULT_PRELINK_QUERY_PACKETS		1	//	
#define	SLAVE_DEVICE_DEFAULT_PRELINK_QUERY_PACKETS	1	//	no of packets sent prior to issuing the link request
#define	DEFAULT_ROAMING_SUPPORT                 	0	//
#define	DEFAULT_RF_POWER_BOOST                   	0	//

//definds for RF roaming
#define RF_BEACON_RATE  2500           //2.5 SECONDS
#define RF_CONN_CHECK_RATE  3000       //3 SECONDS
#define MAX_ROAMING_SUPPORT  MAX_ROAMING_DESCRIPTIVE_TABLE_ENTRIES
#define GW_RM_DEFALT_MV_AV_FILTER_SZ  1
enum{
    ROAMING_AGG_VERYHIGH = 0,
    ROAMING_AGG_HIGH,
    ROAMING_AGG_DEFAULT,
    ROAMING_AGG_LOW,
    ROAMING_AGG_VERYLOW
};
////////////////////////////////////////////////////////////////////////////////
//	externs	
////////////////////////////////////////////////////////////////////////////////
extern const unsigned char RF_Version[];	

////////////////////////////////////////////////////////////////////////////////
//	DECLARATIONS	
////////////////////////////////////////////////////////////////////////////////
extern void		RFAPPInit(void);
extern UINT16	RFAPP_AcquireStart (UINT32 timeout);
extern UINT16	RFAPP_AcquireStop (BOOL ReStartNetwork);
extern BOOL		RFAPP_AcquireStatus (void);
extern UINT32	RFAPP_AcquireRemainingTime (void);	
extern UINT16	RFAPP_PostToPipe (UINT8 *pbuf, UINT16 buflen);
extern INT32	RFAPP_PostEchoRequest (TYPE_RF_ECHO_REQUEST_PACKET *pEchoReq);
extern UINT16	RFAPP_EstablishConnectionwithGateway (UINT8 *pgatewayuid, UINT16 gatewaypanid, UINT8 channel, UINT8 gatewayaddrmode);
extern void		RFAPP_ConnectionFailedwithGateway (void);
extern BOOL		RFAPP_IsSerialCresnetConnected (void);
extern void		RFAPP_EthernetCIPConnected (void);
extern void		RFAPP_EthernetCIPDisConnected (void);
extern void		RFAPP_CresnetBufferOverflow(void);
extern INT32	RFAPP_DeviceDataInfoStrChange (UINT8 field, INT8 *pbuf, UINT16 len);
extern INT32	RFAPP_PrepareAndPostDeviceDataInfoStr(UINT8 field);
extern INT32	RFAPP_RFNetworkDiscover(TYPE_RF_DISCOVER_REQUEST *adreq);
extern UINT16	RFAPP_GetRandomNum (void);

extern INT32	RFAPP_PrepareAndSubmitPassToEnterCmd (UINT8 rfid);	
extern INT32	RFAPP_PrepareAndSubmitPassToExitCmd (UINT8 rfid);
extern INT32	RFAPP_PrepareAndSubmitPassToCmd (UINT8 rfid, INT8 *pbuf, UINT8 len);	
extern INT32	RFAPP_PrepareAndSubmitRFRemoteCfgPacket (UINT32 flags, UINT8 *pdevuid, UINT16 devpanid, UINT8 devaddrmode, UINT8 *pgwuid, UINT16 gwpanid, UINT8 gwaddrmode);
extern void		RFAPP_LinkRequestHandlerStart(UINT8 delay);
extern void		RFAPP_LinkRequestHandlerStop (void);
extern BOOL		RFAPP_IsControlSystemOnLine (void);
extern BOOL		RFAPP_IsCresenetOnLine (void);
extern BOOL		RFAPP_IsCIPOnLine (void);
extern INT32	RFAPP_EnableDisableNetworkService (UINT8 serviceID, UINT8 enable);	
extern BOOL		RFAPP_IsNetworkServiceEnabled (UINT8 serviceID);	
#ifdef	RF_NETWORK_MASTER_DEVICE
extern void  	RFAPP_PrepareAndSubmitRFBeaconPacket(void);
#endif

#ifdef  __cplusplus
}
#endif


#endif
/**/
